// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
// vim:set sts=4 ts=8:

// Copyright (c) 2001-2007 International Computer Science Institute
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software")
// to deal in the Software without restriction, subject to the conditions
// listed in the XORP LICENSE file. These conditions include: you must
// preserve this copyright notice, and you cannot mention the copyright
// holders in advertising related to the Software without their permission.
// The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
// notice is a summary of the XORP LICENSE file; the license in that file is
// legally binding.

// $XORP$

#include "libxorp_module.h"
#include "xorp.h"
#include "xlog.h"

#include "timeval.hh"
#include "clock.hh"

#include <sys/sysinfo.h>


ClockBase::~ClockBase()
{
}

SystemClock::SystemClock() : _ct(0), _last_uptime(0)
{
    _tv = new TimeVal();
    SystemClock::advance_time();
}

SystemClock::~SystemClock()
{
    delete _tv;
}

void
SystemClock::advance_time()
#ifndef HOST_OS_WINDOWS
{
    struct timeval t;
    struct sysinfo si;
    sysinfo(&si);
    t.tv_sec = si.uptime;
    if ((uint32_t)si.uptime != _last_uptime) {
	_last_uptime = si.uptime;
	_ct = 0;
    }
    t.tv_usec = _ct++;

    /*
    ::gettimeofday(&t, 0);
    */
    _tv->copy_in(t);
}
#else /* HOST_OS_WINDOWS */
{
    FILETIME ft;

    ::GetSystemTimeAsFileTime(&ft);
    _tv->copy_in(ft);
}
#endif /* !HOST_OS_WINDOWS */

void
SystemClock::current_time(TimeVal& tv)
{
    tv = *_tv;
}
