/*
 *  Copyright 2006, Vyatta, Inc.
 *
 *  GNU General Public License
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *  02110-1301 USA
 *
 *  Module:       vrrp_set.hh
 *
 *  Author(s):    Michael Larson
 *  Date:         2006
 *  Description:  Class used to interface with rtrmgr and fea
 *
 */

#ifndef _VRRP_SET_H_
#define _VRRP_SET_H_

void vrrp_init();

void vrrp_shutdown();

void vrrp_poll();

void set_address(char *iface, char *addr, int masklen);

void delete_address(char *iface, char *addr);

int set_mac(char *iface, char *mac);
int delete_mac(char *iface);

#endif 
