/*
 * Module: rl_elapsed_counter.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2006
 * Description:
 *
 * **** End License ****
 *
 */

#include <sys/sysinfo.h>

#include "rl_elapsed_counter.hh"

using namespace std;

/**
 * Note that clock_gettime() is not used due to a dependency on
 * pthreads which causes a problem with xorp. Although this would
 * be the best approach.
 *
 **/

/**
 *
 **/
RLClock::RLClock() : 
  _set_time(0)
{

}

/**
 *
 **/
RLClock::~RLClock()
{

}

/**
 *
 **/
unsigned long 
RLClock::get_cpu_time()
{
  /* Obtain system statistics. */
  struct sysinfo si;
  sysinfo (&si);
  return unsigned(si.uptime);// / CLOCKS_PER_SEC;
}

/**
 *
 **/
void
RLClock::set()
{
  struct sysinfo si;
  sysinfo (&si);
  _set_time = unsigned(si.uptime);
}

/**
 *
 **/
unsigned long
RLClock::get_elapsed_time()
{
  struct sysinfo si;
  sysinfo (&si);
  unsigned t = unsigned(si.uptime);

  //handle the condition where the time is set back....
  if (_set_time > t) {
    _set_time = t;
    return 0;
  }

  //ignore the condition where time is pushed forward

  return unsigned(t) - _set_time;
}


/*
#include <iostream>
#include <unistd.h>
#include <pthread.h>
#include "rl_elapsed_counter.hh"

RLElapsedCounter *RLElapsedCounter::_counter = NULL;

extern "C" void*
init_rl_elapsed_counter_thread(void *counter) 
{
  if (counter != NULL) {
    ((RLElapsedCounter*)counter)->run();
  }
  return NULL;
}

RLMutex::RLMutex()
{
  //init the lock here
  pthread_mutex_init(&_mutex, NULL);
  
}

RLMutex::~RLMutex()
{
  pthread_mutex_destroy(&_mutex);
}

RLElapsedCounter::RLElapsedCounter() : 
  _elapsed_time(0),
  _shutdown(false)
{
}

RLElapsedCounter::~RLElapsedCounter()
{

}

void
RLElapsedCounter::start()
{
  
  pthread_create(&_pthread, NULL, &init_rl_elapsed_counter_thread, this);
}

void
RLElapsedCounter::init()
{
  _counter = new RLElapsedCounter();
  _counter->start();
}

bool
RLElapsedCounter::active()
{
  return (_counter == NULL ? false : true);
}

long
RLElapsedCounter::time()
{
  if (_counter == NULL) {
    return -1;
  }
  //Note: wrap mutex into seperate class
  RLMutex m;
  return _counter->_elapsed_time;
}

bool
RLElapsedCounter::is_shutdown()
{
  return _counter->_shutdown;
}

void
RLElapsedCounter::run()
{
  while (!is_shutdown()) {
    {
      //scope the mutex outside of the sleep
      RLMutex m;
      ++_elapsed_time;
    }
    sleep(1);
  }
}
*/
