// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2001-2007 International Computer Science Institute
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software")
// to deal in the Software without restriction, subject to the conditions
// listed in the XORP LICENSE file. These conditions include: you must
// preserve this copyright notice, and you cannot mention the copyright
// holders in advertising related to the Software without their permission.
// The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
// notice is a summary of the XORP LICENSE file; the license in that file is
// legally binding.

// $XORP$

#ifndef __LIBXIPC_FINDER_SERVER_HH__
#define __LIBXIPC_FINDER_SERVER_HH__

#include <list>

#include "libxorp/xlog.h"

#include "finder.hh"
#include "finder_constants.hh"
#include "finder_unix_messenger.hh"
#include "finder_xrl_target.hh"
#include "permits.hh"
#include "sockutil.hh"

/**
 * A wrapper class for the components within a Finder.
 *
 * Instantiates a Finder object and IPC infrastructure for Finder to accept
 * accept incoming connections.
 */
class FinderServerUnix {
public:
    typedef list<FinderUnixListener*> Listeners;

public:

    /**
     * Constructor
     */
    FinderServerUnix(EventLoop& e, const string& default_path)
	throw (InvalidAddress);

    /**
     * Destructor
     */
    ~FinderServerUnix();

    /**
     * Add an additional socket path to accept connections on.
     *
     * @return true on success, false if binding already exists or cannot be
     * instantiated.
     */
    bool add_binding(const string& path)
	throw (InvalidAddress);

    /**
     * Remove socket path binding that was added by calling add_binding.
     * @return true on success, false if binding does not exist or was
     * not added by add_binding.
     */
    bool remove_binding(const string& path);

    /**
     * Accessor to the number of connections the Finder has.
     */
    inline uint32_t connection_count() const	{ return _f.messengers(); }

    string path() const { return _listeners.front()->path(); }

protected:
    EventLoop&		_e;
    Finder		_f;
    FinderXrlTarget	_fxt;
    Listeners		_listeners;
};

#endif // __LIBXIPC_FINDER_SERVER_HH__
