// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2001-2007 International Computer Science Institute
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software")
// to deal in the Software without restriction, subject to the conditions
// listed in the XORP LICENSE file. These conditions include: you must
// preserve this copyright notice, and you cannot mention the copyright
// holders in advertising related to the Software without their permission.
// The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
// notice is a summary of the XORP LICENSE file; the license in that file is
// legally binding.

#ident "$XORP$"

#include "finder_module.h"
#include "finder_server_unix.hh"

FinderServerUnix::FinderServerUnix(EventLoop& e, const string& default_path)
    throw (InvalidAddress)
    : _e(e), _f(e), _fxt(_f)
{
    char* value;
    string finder_path = default_path;

    // Set the finder server socket path from the environment variable if it is set
    value = getenv("XORP_FINDER_SERVER_PATH");
    if (value != NULL) {
	if (!*value != '/') {
	    XLOG_ERROR("Failed to change the Finder server address to %s", value);
	} else {
	    finder_path = string(value);
	}
    }

    add_binding(finder_path);
}

FinderServerUnix::~FinderServerUnix()
{
    while (_listeners.empty() == false) {
	delete _listeners.front();
	_listeners.pop_front();
    }
}

bool
FinderServerUnix::add_binding(const string& path)
    throw (InvalidAddress)
{
    Listeners::const_iterator i = _listeners.begin();
    while (i != _listeners.end()) {
	FinderUnixListener* pl = *i;
	if (pl->path() == path)
	    return false;
	i++;
    }
    try {
        _listeners.push_back(
	    new FinderUnixListener(_e, _f, _f.commands(), path)
	    );
    } catch (const std::bad_alloc&) {
	return false;
    }
    return true;
}

bool
FinderServerUnix::remove_binding(const string& path)
{
    Listeners::iterator i = _listeners.begin();
    while (i != _listeners.end()) {
	FinderUnixListener* pl = *i;
	if (pl->path() == path) {
	    delete *i;
	    _listeners.erase(i);
	    return true;
	}
    }

    return false;
}
