// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_WIN32_DECLS_H__
#define __TPL_WIN32_DECLS_H__

#include <windows.h>
#define TPL_WIN32
#define TPL_I386

#if defined (_MSC_VER)

#  if defined(_DEBUG)
#    define TPL_DEBUG
#  endif

#  if !defined(_MT)
#    error "You must build with multithreaded run-time!"
#  endif

#  if defined(ERT_DLL) && !defined(_DLL)
#    error "You must link with dynamic run-time!"
#  endif

#  define TPL_CRT_HAS_SNPRINTF
#  define snprintf  _snprintf
#  define vsnprintf _vsnprintf

#  define TPL_FASTCALL __fastcall
// "C4355: 'this' : used in base member initializer list"
#  pragma warning(disable:4355)

#else // (_MSC_VER)
  #error This compiler is not supported

#endif // (_MSC_VER)

#if defined(TPL_SHARED)
  #if defined(TPL_DLL_BUILD)  
    #define TPL_EXPORT  __declspec(dllexport)
  #else
    #define TPL_EXPORT  __declspec(dllimport)
  #endif
#else 
  #define TPL_EXPORT
  #if !defined(TPL_NO_STATIC_OBJECT_MANAGER)
  # define TPL_STATIC_OBJECT_MANAGER
  #endif
#endif

#endif // __TPL_WIN32_DECLS_H__
