// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                   ref_count_rep<T>                     //
////////////////////////////////////////////////////////////

template <typename T>
ref_count_rep<T>::ref_count_rep(T* ptr) : _ptr(ptr), _counter(0)
{
}

template <typename T>
ref_count_rep<T>::~ref_count_rep()
{
    TPL_ASSERT(!_counter);
    if (_ptr)
    	delete _ptr;
    _ptr = 0;
}

////////////////////////////////////////////////////////////
//               ref_count_array_rep<T>                   //
////////////////////////////////////////////////////////////

template <typename T>
ref_count_array_rep<T>::ref_count_array_rep(T* ptr)  : ref_count_rep<T>(ptr)
{
}

template <typename T>
ref_count_array_rep<T>::~ref_count_array_rep()
{
    TPL_ASSERT(!_counter);
    if (ref_count_rep<T>::_ptr)
    	delete [] ref_count_rep<T>::_ptr;
    ref_count_rep<T>::_ptr = 0;
}

////////////////////////////////////////////////////////////
//                   smart_ptr<T, REP>                    //
////////////////////////////////////////////////////////////

template <typename T, template <class> class REP>
smart_ptr<T, REP>::smart_ptr(T* ptr)
{
    if (ptr) {
    	_rep = new REP<T>(ptr);
    	_rep->inc_ref_count();
    }
}

template <typename T, template <class> class REP>
smart_ptr<T, REP>::smart_ptr(const smart_ptr& other) : _rep(other._rep)
{
    if (_rep)
    	_rep->inc_ref_count();
}

template <typename T, template <class> class REP>
smart_ptr<T, REP>&
smart_ptr<T, REP>::operator= (const smart_ptr<T, REP>& other)
{
    if (other._rep)
    	other._rep->inc_ref_count();
    unref();
    _rep = other._rep;
    return *this;
}

template <typename T, template <class> class REP>
void
smart_ptr<T, REP>::unref() {
    if (_rep && _rep->dec_ref_count() == 1)
    	delete _rep;
    _rep = 0;
}

template <typename T, template <class> class REP>
void
smart_ptr<T, REP>::print_on(std::ostream& os) const
{
    if (!is_null())
        os << _rep->get_ptr();
}
