// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_HANDLE_HH__
#define __TPL_HANDLE_HH__

#include <iostream>

namespace tpl {

/**
 *  handled pointer representation
 */
template<typename T>
class handle;

template<typename T>
inline bool operator== (const handle<T>& lhs, const handle<T>& rhs)
{
    return lhs._ptr == rhs._ptr;
}

template<typename T>
inline bool operator> (const handle<T>& lhs, const handle<T>& rhs)
{
    return (lhs._ptr > rhs._ptr);
}

template<typename T>
inline bool operator< (const handle<T>& lhs, const handle<T>& rhs)
{
    return (lhs._ptr < rhs._ptr);
}

template<typename T>
inline bool operator!= (const handle<T>& lhs, const handle<T>& rhs)
{
   return !(lhs == rhs);
}

template<typename T>
inline bool operator>= (const handle<T>& lhs, const handle<T>& rhs)
{
   return !(lhs < rhs);
}

template<typename T>
inline bool operator<= (const handle<T>& lhs, const handle<T>& rhs)
{
   return !(lhs > rhs);
}

template<typename T>
inline std::ostream& operator<< (std::ostream& os, const handle<T>& obj)
{
    obj.print_on(os);
    return os;
}

/**
 *  Implements basic concept of an object handle
 */
template<typename T>
class handle
{
public:  // Create/Copy/Destroy

    handle() : _ptr(0) {}

    handle(T* ptr) : _rep(0) {}

    ~handle() { _ptr = 0; }

public:  //// Usage

    T* operator->() const { return _ptr;  }

    const T* operator->() const { return _ptr; }

    T& operator*() const { return *(_ptr); }

    bool is_null() const { return _ptr == 0; }

    friend bool operator== <T>(const handle<T>& lhs, const handle<T>& rhs);

    friend bool operator> <T>(const handle<T>& lhs, const handle<T>& rhs);

    friend bool operator< <T>(const handle<T>& lhs, const handle<T>& rhs);

    friend std::ostream& operator<< <T>(std::ostream& os, const handle<T>& obj);

private:

    void print_on (std::ostream& os) const {
        os << _ptr;
    }

    T* _ptr;
};

}; // namespace tpl

#endif // __TPL_HANDLE_HH__
