// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_C_TYPE_HH__
#define __TPL_C_TYPE_HH__

#include <bits/cpp_type_traits.h>
#include <iostream>
#include <sstream>
#include <string>

namespace tpl {

template <class T>
class c_type;

template <class T>
inline std::ostream& operator<< (std::ostream& os, const c_type<T>& obj)
{
    obj.print_on ( os );
    return os;
}

/**
 *  Wrapper for basic C types.
 *  XXX: c_type can be used everywhere where basic C type can be used.
 *  In addition it has build-in conversion operators that makes it convinient to
 *  use in the conjunction with strings. 
 */
template <class T>
class c_type
{
public:  // Create/Copy/Destroy

    c_type(T var) : _var(var) {}
    virtual ~c_type() {}

public:  // Conversion operators

    /**
     *  Converts to T.
     *  XXX: allows to use it as T in proper context.
     */
    operator const T() const { return _var; }

    /**
     *  Converts to string.
     *  Notes: allows to use it as a string.
     */
    operator const std::string() const {
    	std::stringstream s;
    	s << _var; s.flush();
    	return std::string(s.str());
    }

public:  // Printing

    friend std::ostream& operator<< <T>(std::ostream& os, const c_type<T>& obj);

protected:

    virtual void print_on(std::ostream& os) const {
    	os << _var;
    }

private:

    T _var;  // Basic C type variable.
};

template <typename T>
bool is_fundamental(T& val)
{
    struct std::__is_fundamental<T> test;

    if (test._M_type)
    	return true;

    return false;
}

}; // namespace tpl

#endif  //__TPL_C_TYPE_HH__
