// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_ARRAY_PTR_HH__
#define __TPL_ARRAY_PTR_HH__

namespace tpl {

/**
 *  temporary holder for compatible types conversion
 */
template <typename T>
struct array_ptr_ref
{
    mutable T* _ptr;

    explicit array_ptr_ref(T* p) : _ptr(p) {}
};

/**
 *  auto pointer for array variables
 */
template <typename T>
class array_ptr
{
public:
    typedef array_ptr<const T> const_array_ptr;

public:  // Create/Copy/Destroy

    explicit array_ptr(T* p = 0) : _ptr(p) {}

    array_ptr(array_ptr& other) : ptr_(other.release()) {}

    template<typename T1>
    array_ptr (array_ptr<T1>& other) : ptr_(other.release()) {}

    array_ptr& operator= (array_ptr& other)
    {
    	reset(other.release);
    	return *this;
    }

    template<typename T1>
    array_ptr& operator= (array_ptr<T1>& other)
    {
    	reset(other.release);
    	return *this;
    }

    ~array_ptr()
    {
    	delete [] _ptr;
    }

    inline T& operator* () const { return *_ptr; }

    T* operator-> () const { return _ptr; }

    T& operator[] (int i) const { return _ptr[i]; }

    T* get() const { return _ptr; }

    T* release() const
    {
    	T* tmp = ptr_;
    	ptr_ = 0;
    	return tmp;
    }

    void reset(T* p = 0)
    {
    	if (p != _ptr) {
    	    delete [] _ptr;
    	    _ptr = p;
    	}
    }

    array_ptr(array_ptr_ref<T> ref) : _ptr(ref._ptr) {}

    array_ptr&  operator= (array_ptr_ref<T> ref)
    {
    	if (ref.ptr_ != this->get()) {
    	    delete [] _ptr;
    	    _ptr = ref._ptr;
    	}
    }

    template<typename T1>
    operator array_ptr_ref<T1>()
    {
    	return array_ptr_ref<T1>(this->release());
    }

    template<typename T1>
    operator array_ptr<T1>()
    {
    	return array_ptr<T1>(this->release());
    }

private:

    mutable T* _ptr;
};

};  // namespace tpl

#endif // __TPL_ARRAY_PTR_HH__
