// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_DECLS_HH__
#define __TPL_DECLS_HH__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define FAT_INTERFACE

#if defined(HOST_OS_WINDOWS)
#  include "win32_decls.h"
#else
#  if defined(TPL_SHARED)
#    define TPL_EXPORT
#  else 
#    define TPL_EXPORT
#    define TPL_STATIC_OBJECT_MANAGER
#  endif

typedef int fd_type;
typedef int sock_type;

#define TPL_BAD_FD	((fd_type) -1)
#define TPL_BAD_SOCKET  TPL_BAD_FD

#endif

#define TPL_NO_COPY(ClassName)        \
  private:                            \
    ClassName(const ClassName&);      \
    void operator=(const ClassName&)

#define TPL_NO_COPY_TEMPLATE(ClassName, TemplateParams...) \
  private:                                              \
    ClassName(const ClassName<TemplateParams>&);        \
    void operator=(const ClassName<TemplateParams>&)

#endif // __TPL_DECLS_HH__
