// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include <errno.h>

#include "thread.hh"
#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                     ThreadRunner                       //
////////////////////////////////////////////////////////////

template <class THREAD, template <class> class DISPATCHER>
ThreadRunner<THREAD, DISPATCHER>::ThreadRunner() : _target(this), _retval(0)
{
}

template <class THREAD, template <class> class DISPATCHER>
ThreadRunner<THREAD, DISPATCHER>::ThreadRunner(Runnable *target) : _target(target), _retval(0)
{
}

template <class THREAD, template <class> class DISPATCHER>
ThreadRunner<THREAD, DISPATCHER>::~ThreadRunner()
{
}

template <class THREAD, template <class> class DISPATCHER>
void
ThreadRunner<THREAD, DISPATCHER>::start()
{
    if (!DISPATCHER<THREAD>::is_started()) {
    	DISPATCHER<THREAD>::set_thread_function(thread_proc);
    	DISPATCHER<THREAD>::start(_target);
    }
}

template <class THREAD, template <class> class DISPATCHER>
void
ThreadRunner<THREAD, DISPATCHER>::run()
{
}

template <class THREAD, template <class> class DISPATCHER>
void*
ThreadRunner<THREAD, DISPATCHER>::thread_proc(void* arg)
{
    Runnable* p = static_cast<Runnable*>(arg);
    try {
    	p->run();
    }
    catch (...) {
    	std::cerr << "Thread " << THREAD::current_thread_id()
    	     << ": Unknown exception caught on a thread" << std::endl;
    }

    return 0;
}

template <class THREAD, template <class> class DISPATCHER>
void
ThreadRunner<THREAD, DISPATCHER>::join()
{
    while (true) {
    	int err = DISPATCHER<THREAD>::join(&_retval);
    	if (err == EINTR)
    	    continue;

    	TPL_ASSERT(err == 0);
    	break;
    }
}

template <class THREAD, template <class> class DISPATCHER>
int
ThreadRunner<THREAD, DISPATCHER>::exit_code() const
{
    const void *ptr = &(_retval);
    const int *p = reinterpret_cast<const int*>(ptr);
    return *p;
}

template <class THREAD, template <class> class DISPATCHER>
void
ThreadRunner<THREAD, DISPATCHER>::print_on(std::ostream& os) const
{
    os << DISPATCHER<THREAD>::id();
}

//------------------------------------------------------------
// Template Instantiations

#if defined(FAT_INTERFACE)
#  if defined(TPL_WIN32)
template class ThreadRunner<WinThread, ThreadDispatcher>;
#  else // !TPL_WIN32
template class ThreadRunner<PosixThread, ThreadDispatcher>;
#  endif // !TPL_WIN32
#endif  // FAT_INTERFACE
