//  test_thread.cc

#include "thread.hh"
#include "mutex.hh"
#include "condition.hh"
#include "lock_guards.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

void* thread_function(void *);
void test_thread();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_thread();

    return 0;
}

void test_thread()
{
    Thread t1;
    t1.set_thread_function(thread_function);
    Thread t2;
    t2.set_thread_function(thread_function);
    char name_t1[9] = "thread 1";
    char name_t2[9] = "thread 2";

    t1.start(name_t1);
    t2.start(name_t2);
    cout << "thread 1 ID: " << t1.id() << endl;
    cout << "thread 2 ID: " << t2.id() << endl;

    void **rc = 0;
    t1.join(rc);
    t2.join(rc);
}

void* thread_function(void *ctx)
{
    char *str = static_cast<char*>(ctx);
    cout << "Thread: " << str << ", ID: " << Thread::current_thread_id() << endl;
    return 0;
}

