//  test_lock.cc

#include "mutex.hh"
#include "spinlock.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

void test_spinlock();
void test_mutex();
void test_recursive_mutex();
void test_safe_mutex();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);

    test_spinlock();
    test_mutex();
    test_recursive_mutex();
    test_safe_mutex();

    return 0;
}

void test_spinlock()
{
    Spinlock lock;
    cout << "Spinlock trylock...";
    lock.try_lock();
    cout << "succeeded" << endl;
    lock.unlock();
    cout << "Spinlock lock...";
    lock.lock();
    cout << "succeeded" << endl;
    lock.unlock();
}

void test_mutex()
{
    Mutex mutex;
    cout << "Mutex trylock...";
    mutex.try_lock();
    cout << "succeeded" << endl;
    mutex.unlock();
    cout << "Mutex lock...";
    mutex.lock();
    cout << "succeeded" << endl;
    mutex.unlock();
}

void test_recursive_mutex()
{
    RecursiveMutex mutex;
    cout << "RecursiveMutex trylock...";
    mutex.try_lock();
    cout << "succeeded" << endl;
    mutex.unlock();
    cout << "RecursiveMutex lock...";
    mutex.lock();
    cout << "succeeded" << endl;
    mutex.unlock();
}

void test_safe_mutex()
{
    SafeMutex mutex;
    cout << "SafeMutex trylock...";
    mutex.try_lock();
    cout << "succeeded" << endl;
    mutex.unlock();
    cout << "SafeMutex lock...";
    mutex.lock();
    cout << "succeeded" << endl;
    mutex.unlock();
}
