// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_SPINLOCK_HH__
#define __TPL_SPINLOCK_HH__

#include "libtpl/tpl_decls.hh"

#if defined(TPL_WIN32)

#include "bits/win32_lock_objects.hh"

namespace tpl {
typedef WinSpinlock Spinlock;
};

#else // !TPL_WIN32

#include "bits/posix_lock_objects.hh"

namespace tpl {
typedef PosixSpinlock<> Spinlock;
};

#endif // !TPL_WIN32

#endif // __TPL_SPINLOCK_HH__
