// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_RW_LOCK_HH__
#define __TPL_RW_LOCK_HH__

#include "condition.hh"
#include "mutex.hh"

namespace tpl {

/**
 *  @short Read/Write Lock wrapper class
 */
class ReadWriteLock
{
public:  // Create/Copy/Destroy

    ReadWriteLock();

    virtual ~ReadWriteLock();

    TPL_NO_COPY(ReadWriteLock);

public:  // Usage

    /**
     *  Try to acquire read lock
     */
    bool try_read_lock();

    /**
     *  Acquire read lock
     */
    void read_lock();

    /**
     *  Try to acquire write lock
     */
    bool try_write_lock();

    /**
     *  Acquire write lock
     */
    void write_lock();

    /**
     *  Release lock
     */
    void unlock();

public:  // State

    /**
     *  @return number of threads waiting for reading
     */
    int waiting_readers() const;

    /**
     *  @return number of threads waiting for writing
     */
    int waiting_writers() const;

    /**
     *  @return number of active reading threads
     */
    int active_readers() const;

    /**
     *  Returns number of active writers (should be one)
     */
    int active_writers() const;

private:

    int _active_readers;
    int _active_writers;
    int _waiting_readers;
    int _waiting_writers;

    Mutex _mutex;
    Condition _read_cond;
    Condition _write_cond;
};

};

#endif //__TPL_RW_LOCK_HH__
