// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_RUNNABLE_HH__
#define __TPL_RUNNABLE_HH__

#include "libtpl/tpl_decls.hh"

#include <iostream>

namespace tpl {

/**
 *  @short A runnable object interface.
 *  This interface should be implemented by any class whose instances can be
 *  executed by a thread.
 */
class Runnable
{
public:  // Create/Copy/Destroy

    Runnable() {}
    virtual ~Runnable() {}

    TPL_NO_COPY(Runnable);

public:  // Usage

    /**
     *  Thread execution method of a runnable object.
     *  As soon as thread is started object's run method is called in that separately executing thread.
     */
    virtual void run() = 0;

public:  // Printing

    friend inline std::ostream& operator<< (std::ostream& os, const Runnable& obj);

protected:

    virtual void print_on(std::ostream& os) const = 0;

};

inline std::ostream& operator<< (std::ostream& os, const Runnable& obj)
{
    obj.print_on ( os );
    return os;
}

};  // namespace tpl


#endif // __TPL_RUNNABLE_HH__
