// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "mutex.hh"
#include "condition.hh"
#include "libtpl/debug.hh"

using namespace tpl;

template <class MUTEX>
MutexLock<MUTEX>::MutexLock()
{
}

template <class MUTEX>
MutexLock<MUTEX>::~MutexLock()
{
}

template <class MUTEX>
Synchronizer*
MutexLock<MUTEX>::new_synchronizer() const
{
    return new Condition(*this);
}

//------------------------------------------------------------
// Template Instantiations

#if defined(FAT_INTERFACE)
#  if defined(TPL_WIN32)
template class MutexLock<WinMutex>;
template class MutexLock<WinThreadMutex>;
template class MutexLock<WinMutex>;
#  else // !TPL_WIN32
template class MutexLock<PosixMutex<PosixMutexAttributes::NORMAL> >;
template class MutexLock<PosixMutex<PosixMutexAttributes::RECURSIVE> >;
template class MutexLock<PosixMutex<PosixMutexAttributes::ERRORCHECKING> >;
#  endif // !TPL_WIN32
#endif  // !FAT_INTERFACE
