// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_MONITOR_HH__
#define __TPL_MONITOR_HH__

#include "lock.hh"

#include <iostream>

namespace tpl {

/**
 *  @short Base class for lockable objects
 */
class Monitor
{
public:  // Create/Copy/Destroy

    Monitor() {}

    virtual ~Monitor() {}

    // Do not copy state of the mutex object!!!
    Monitor(const Monitor&) {}

    const Monitor& operator= (const Monitor&) { return *this; }

public:  // Usage

    /**
     *	Try to acquire internal mutex
     */
    bool try_lock() const { return _mutex.try_lock(); }

    /**
     *  Acquire lock on internal mutex
     */
    void lock () const { _mutex.lock(); }

    /**
     *  Unlock internal mutex
     */
    void unlock() const { _mutex.unlock(); }

    /**
     * @return internal mutex object
     */
    const Mutex& mutex() const { return _mutex; }

public:  // Printing

    friend inline std::ostream& operator<< (std::ostream& os, const Monitor& obj);

protected:

    virtual void print_on(std::ostream&) const {}

protected:

    mutable Mutex _mutex;
};

inline std::ostream& operator<< (std::ostream& os, const Monitor& obj)
{
    obj.print_on(os);
    return os;
}

};

#endif //__TPL_MONITOR_HH__
