// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_LOCK_GUARDS_HH__
#define __TPL_LOCK_GUARDS_HH__

#include "libtpl/tpl_decls.hh"

namespace tpl {

/**
 *  @short Scoped lock.
 *  Scoped lock is used to lock objects for the duration of the
 *  lock object life-cycle. Primarily used to lock objects for the duration
 *  of method execution.
 */
template <class LOCK>
class LockGuard
{
public:  // Create/Copy/Destroy

    /**
     *  Locks the LOCABLE object construction.
     */
    LockGuard(const LOCK& lock) : _lock(lock)
    {
    	_lock.lock();
    }

    /**
     *  Unlocks the LOCABLE upon destruction.
     */
    ~LockGuard ()
    {
    	_lock.unlock();
    }

    TPL_NO_COPY_TEMPLATE(LockGuard, LOCK);

private:

    const LOCK& _lock;
}; 

};  // namespace tpl

#endif // __TPL_LOCK_GUARDS_HH__
