// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "condition.hh"
#include "mutex.hh"
#include "libtpl/debug.hh"

using namespace tpl;

template <class CONDITION>
ConditionSynchronizer<CONDITION>::~ConditionSynchronizer()
{
}

template <class CONDITION>
int
ConditionSynchronizer<CONDITION>::wait(unsigned long time_ms) const
{
    return _cond.wait(time_ms);
}

/*
template <class CONDITION>
int
ConditionSynchronizer<CONDITION>::wait_until(const DateTime& deadline) const
{
    return _cond.wait_until(deadline);
}
*/

//------------------------------------------------------------
// Template Instantiations

#if defined(FAT_INTERFACE)
#  if defined(TPL_WIN32)
template class ConditionSynchronizer<WinCondition>;

namespace tpl {

template <> template <>
ConditionSynchronizer<WinCondition>::ConditionSynchronizer(const Mutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<WinCondition>::ConditionSynchronizer(const SafeMutex& lock) :
 _cond(lock.handle()) {}

};

#  else // !TPL_WIN32
template class ConditionSynchronizer<PosixCondition<CONDITION_STATELESS> >;
template class ConditionSynchronizer<PosixCondition<CONDITION_STATEFULL> >;

namespace tpl {

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATELESS> >::ConditionSynchronizer(const Mutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATELESS> >::ConditionSynchronizer(const RecursiveMutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATELESS> >::ConditionSynchronizer(const SafeMutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATEFULL> >::ConditionSynchronizer(const Mutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATEFULL> >::ConditionSynchronizer(const RecursiveMutex& lock) :
 _cond(lock.handle()) {}

template <> template <>
ConditionSynchronizer<PosixCondition<CONDITION_STATEFULL> >::ConditionSynchronizer(const SafeMutex& lock) :
 _cond(lock.handle()) {}

};

#  endif // !TPL_WIN32
#endif  // FAT_INTERFACE

