// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_WIN32_HANDLE_HH__
#define __TPL_WIN32_HANDLE_HH__

#ifndef WIN32_LEAN_AND_MEAN
#  define WIN32_LEAN_AND_MEAN
#endif

#define KERNEL_EXPORT(type) __declspec(dllexport) type __stdcall
#define KERNEL_API(type) extern "C" KERNEL_EXPORT(type)

class TPL_EXPORT WinHandle
{
public:  // Create/Copy/Destroy

    WinHandle(HANDLE handle = 0): _handle(handle) {}

    ~WinHandle() {
    	close();
    }

    TPL_NO_COPY(WinHandle);

public:  // Usage

    operator HANDLE() const { return _handle; }

    void assign(HANDLE handle) {
    	close();
    	_handle = handle;
    }

protected:

    void close() {
    	if (_handle && (_handle != INVALID_HANDLE_VALUE))
    	    ::CloseHandle(_handle);
    }

protected:
    mutable HANDLE _handle;
};

};  // namespace tpl

#endif // __TPL_WIN32_HANDLE_HH__
