// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "libtpl/debug.hh"

#include <stdarg.h>
#include <stdlib.h>

#if defined(TPL_WIN32) && defined(TPL_DEBUG)

#include "StackWalk.h"

#include <process.h>

#if defined(_MSC_VER) 
#include <signal.h>
#endif

static uint32_t         __tpl_debug_options = 0;
static unsigned long      __tpl_gui_thread_id = 0;
static stack_print_hook_t __tpl_stack_print_hook = 0;

static uint32_t __stdcall __show_message_box(void* p){
	return ::MessageBox(0, static_cast<const char*>(p), "Debug subsystem", MB_ABORTRETRYIGNORE | MB_ICONSTOP | MB_TASKMODAL);
}

// Debugging
bool __TPL_Assert_Fail(const char* file, unsigned line, const char* expr){
	char _tmp[2048];
	snprintf(
		_tmp, 
		sizeof(_tmp),
		"Assertion failed:\nfile '%s'\nline %d\ntime %d.%d\nCondition: '%s'\n",
		file,
		line,
		int(t / 1000), int(t % 1000),
		expr
		);
	if (__ert_stack_print_hook){
		size_t len = strlen(_tmp);
		__ert_stack_print_hook(_tmp + len, sizeof(_tmp) - len);
		_tmp[sizeof(_tmp) - 1] = 0;
	}

	if (__ert_debug_options & ERT_DEBUG_LOG_ASSERTIONS_ONLY) {
            ASRT_TRACE((ASRT_ERROR, _tmp));
            return false;
	}

	// Show assert window on the screen
	unsigned long res;

	if ((__tpl_debug_options & TPL_DEBUG_BLOCK_GUI_THREAD) && __tpl_gui_thread_id == GetCurrentThreadId()) {
		uint32_t tid;
		HANDLE h = ::CreateThread(0, 0, __show_message_box, _tmp, 0, &tid);
		if (!h)
			res = __show_message_box(_tmp);
		else {
			::WaitForSingleObject(h, INFINITE);
			::GetExitCodeThread(h, &res);
			::CloseHandle(h);
		}
	}
	else
		res = __show_message_box(_tmp);

	if (res == IDABORT){
#if defined(_MSC_VER) 
		raise(SIGABRT);     /* raise abort signal */
		_exit(3);
#else
		abort();
#endif
	}
		return res == IDRETRY;
	} else {
		return false;
	}
#endif
}

void __TPL_Debug_Break(){
    ::DebugBreak();
}

void __TPL_Trace(const char* format, ...){

    char buf[1024];

    va_list l;
    va_start(l, format);
    snprintf(buf, sizeof(buf), format, l);
    va_end(l);

    ::OutputDebugString(buf);
}

void __TPL_Set_Debug_Option(uint32_t options){

    __tpl_debug_options = options;

    if (__tpl_debug_options & ERT_DEBUG_BLOCK_GUI_THREAD)
    	__tpl_gui_thread_id = ::GetCurrentThreadId();
}

void __TPL_Set_Stack_Print_Hook(t_stack_print_hook hook){
    __ert_stack_print_hook = hook;
}

#endif // TPL_WIN32 && TPL_DEBUG
