//  test_priority_queue.cc

#include "libtpl/thread/thread.hh"
#include "priority_queue.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

PriorityQueue<int> *queue;

const int PRIORITY_NORMAL = 5;
const int PRIORITY_HIGH = 1;

void* thread_function1(void *);
void* thread_function2(void *);
void* thread_function3(void *);
void test_priority_queue();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_priority_queue();

    return 0;
}

void test_priority_queue()
{
    queue = new PriorityQueue<int>();
    queue->create_queue(PRIORITY_NORMAL);
    queue->create_queue(PRIORITY_HIGH);
    Thread t1;
    t1.set_thread_function(thread_function1);
    Thread t2;
    t2.set_thread_function(thread_function2);
    Thread t3;
    t3.set_thread_function(thread_function3);

    t1.start(0);
    t2.start(0);
    t3.start(0);

    void **rc = 0;
    t1.join(rc);
    t2.join(rc);
    queue->deactivate();
    t3.join(rc);
    delete queue;
}

void* thread_function1(void *ctx)
{
    UNUSED(ctx);
    //sleep(1);
    cout << "Thread-1 ID: " << Thread::current_thread_id() << endl;
    for (int i = 100; i < 110; ++i) {
        int *msg = new int(i);
    	queue->put(PRIORITY_NORMAL, msg);
        //sleep(1);
    }
    cout << "Thread-1 exiting..." << endl;
    return 0;
}

void* thread_function2(void *ctx)
{
    UNUSED(ctx);
    sleep(1);
    cout << "Thread-2 ID: " << Thread::current_thread_id() << endl;
    for (int i = 200; i < 210; ++i) {
        int *msg = new int(i);
    	queue->put(PRIORITY_HIGH, msg);
        //sleep(1);
    }
    cout << "Thread-2 exiting..." << endl;
    return 0;
}

void* thread_function3(void *ctx)
{
    UNUSED(ctx);
    sleep(1);
    cout << "Thread-3 ID: " << Thread::current_thread_id() << endl;
    cout << "Ready priority: " << queue->ready_priority() << endl;
    int *msg = 0;
    do {
    	msg = queue->get();
        if (msg != 0)
            cout << "msg: " << *msg << endl;
    } while (msg != 0);
    cout << "Thread-3 exiting..." << endl;
    return 0;
}

