//  test_queue.cc

#include "libtpl/thread/thread.hh"
#include "multi_queue.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

MultiQueue<int> *queue;

void* thread_function1(void *);
void* thread_function2(void *);
void* thread_function3(void *);
void test_multi_queue();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_multi_queue();

    return 0;
}

void test_multi_queue()
{
    queue = new MultiQueue<int>();
    int q1 = queue->create_queue();
    int q2 = queue->create_queue();
    Thread t1;
    t1.set_thread_function(thread_function1);
    Thread t2;
    t2.set_thread_function(thread_function2);
    Thread t3;
    t3.set_thread_function(thread_function3);

    t1.start(&q1);
    t2.start(&q2);
    t3.start(0);

    void **rc = 0;
    t1.join(rc);
    t2.join(rc);
    t3.join(rc);
    delete queue;
}

void* thread_function1(void *ctx)
{
    int *id = static_cast<int*>(ctx);
    cout << "Thread-1 ID: " << Thread::current_thread_id() << endl;
    for (int i = 100; i < 110; ++i) {
        int *msg = new int(i);
    	queue->put(*id, msg);
        sleep(1);
    }
    queue->deactivate(*id);
    cout << "Thread-1 exiting..." << endl;
    return 0;
}

void* thread_function2(void *ctx)
{
    int *id = static_cast<int*>(ctx);
    cout << "Thread-2 ID: " << Thread::current_thread_id() << endl;
    for (int i = 200; i < 210; ++i) {
        int *msg = new int(i);
    	queue->put(*id, msg);
        sleep(1);
    }
    queue->deactivate(*id);
    cout << "Thread-2 exiting..." << endl;
    return 0;
}

void* thread_function3(void *ctx)
{
    UNUSED(ctx);
    cout << "Thread-2 ID: " << Thread::current_thread_id() << endl;
    int *msg = 0;
    do {
    	msg = queue->get();
        if (msg != 0)
            cout << "msg: " << *msg << endl;
    } while (msg != 0);
    cout << "Thread-3 exiting..." << endl;
    return 0;
}

