//  test_blocking_queue.cc

#include "libtpl/thread/thread.hh"
#include "linked_queue.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

BlockingQueue<int> *queue;

void* thread_function1(void *);
void* thread_function2(void *);
void test_blocking_queue();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_blocking_queue();

    return 0;
}

void test_blocking_queue()
{
    queue = new LinkedBlockingQueue<int>();
    Thread t1;
    t1.set_thread_function(thread_function1);
    Thread t2;
    t2.set_thread_function(thread_function2);
    char name_t1[9] = "thread 1";
    char name_t2[9] = "thread 2";

    t1.start(name_t1);
    t2.start(name_t2);

    void **rc = 0;
    t1.join(rc);
    t2.join(rc);
    delete queue;
}

void* thread_function1(void *ctx)
{
    char *str = static_cast<char*>(ctx);
    cout << "Thread: " << str << ", ID: " << Thread::current_thread_id() << endl;
    for (int i = 0; i < 5; ++i) {
        int *msg = new int(i);
    	queue->put(msg);
        sleep(1);
    }
    queue->deactivate();
    cout << "Thread: " << str << " exiting..." << endl;
    return 0;
}

void* thread_function2(void *ctx)
{
    char *str = static_cast<char*>(ctx);
    cout << "Thread: " << str << ", ID: " << Thread::current_thread_id() << endl;
    int *msg = 0;
    do {
    	msg = queue->get(2000);
        if (msg != 0)
            cout << "msg: " << *msg << endl;
    } while (msg != 0);
    cout << "Thread: " << str << " exiting..." << endl;
    return 0;
}

