//  test_task.cc

#include "task.hh"
#include "task_policy.hh"
#include "task_mgr.hh"
#include "libtpl/thread/lock_guards.hh"
#include "libtpl/debug.hh"

#include <iostream>
#include <string>

using namespace tpl;
using namespace std;

class TestTask : public Task<RUN_THREAD_ONCE>
{
public:
    TestTask(string name) : _name(name) {}
protected:
    virtual void run();
private:
    string _name;
};

void TestTask::run()
{
    cout << "Thread: " << _name << ", ID: " << Thread::current_thread_id() << endl;
}

// Simple interface test
void test_task();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_task();

    return 0;
}

void test_task()
{
    TestTask t1("task1");
    TestTask t2("task2");

    t1.start();
    t2.start();

    TaskManager* mgr = TaskManager::instance();
    LockGuard<TaskManager> guard(*mgr);
    mgr->join_all();
}
