//  test_active_obj.cc

#include "service.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

class TestService : public Service<int>
{
public:
    TestService(string name) : _name(name) {}
    void stop() { deactivate_queue(); }
protected:
    virtual void run();
private:
    string _name;
};

void TestService::run()
{
    cout << "Thread: " << _name << ", ID: " << Thread::current_thread_id() << endl;
    int *msg = 0;
    do {
    	msg = get();
        if (msg != 0)
            cout << "msg: " << *msg << endl;
    } while (msg != 0);
    cout << "Thread: " << _name << " exiting..." << endl;
}

void test_service();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_service();

    return 0;
}

void test_service()
{
    TestService *service = new TestService("service thread");

    service->start();
    for (int i = 0; i < 20; ++i) {
        int *msg = new int(i);
    	service->put(msg);
        sleep(1);
    }
    service->stop();

    service->join();
    delete service;
}

