//  test_producer_consumer.cc

#include "consumer.hh"
#include "producer.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

class TestConsumer : public Consumer<int>
{
public:
    TestConsumer() {}
protected:
    virtual void process(int *msg);
};

void TestConsumer::process(int *msg)
{
    if (msg != 0)
    	cout << "Consumer: got msg: " << *msg << endl;
}

class TestProducer : public Producer<int>
{
public:
    TestProducer() {}
protected:
    virtual void process();
};

void TestProducer::process()
{
    cout << "Producer: TID: " << Thread::current_thread_id() << endl;
    for (int i = 0; i < 10; ++i) {
    	int *msg = new int(i);
    	put(msg);
    	sleep(1);
    }
    cout << "Producer: exiting..." << endl;
}

void test_producer_consumer();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_producer_consumer();

    return 0;
}

void test_producer_consumer()
{
    TestProducer *producer = new TestProducer();
    TestConsumer *consumer = new TestConsumer();
    producer->register_consumer(consumer);

    consumer->start();
    producer->start();

    producer->join_all();
    producer->unregister_consumer(consumer);

    delete producer;
    delete consumer;
}

