//  test_active_obj.cc

#include "msg_service.hh"
#include "msg_channel.hh"
#include "libtpl/debug.hh"

#include <iostream>

using namespace tpl;
using namespace std;

// Simple interface test

class TestService : public MessageService<int>
{
public:
    TestService(string name, MessageChannel<int> *msg_channel) :
    	MessageService<int>(msg_channel), _name(name) {}
    void stop() { deactivate_queue(); }
protected:
    virtual void run();
private:
    string _name;
};

void TestService::run()
{
    cout << "Service: " << _name << ", TID: " << Thread::current_thread_id() << endl;
    Message<int> *msg = 0;
    do {
    	msg = get();
        if (msg != 0)
            cout << "Service: " << _name << ", got msg: " << *msg << endl;
    } while (msg != 0);
    cout << "Service: " << _name << " exiting..." << endl;
}

void test_message_channel();

int main(int argc, void *argv[])
{
    UNUSED(argc);
    UNUSED(argv);
    test_message_channel();

    return 0;
}

void test_message_channel()
{
    MessageChannel<int> *msg_channel = new MessageChannel<int>();
    TestService *service1 = new TestService("test event service 1", msg_channel);
    TestService *service2 = new TestService("test event service 2", msg_channel);

    msg_channel->start();
    service1->subscribe(1024);
    service2->subscribe(1024);
    service1->start();
    service2->start();

    for (int i = 0; i < 10; ++i) {
        Message<int> *msg = new Message<int>(1024);
    	service1->post_message(msg);
        sleep(1);
    }
    service1->stop();
    service2->stop();
    msg_channel->shutdown();

    service1->join();
    service2->join();
    msg_channel->join();
    delete service1;
    delete service2;
    delete msg_channel;
}

