// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_TASK_POLICY_HH__
#define __TPL_TASK_POLICY_HH__

#include "libtpl/thread/mutex.hh"
#include "libtpl/thread/condition.hh"

namespace tpl {

/**
 *  KEEP_THREAD_ALIVE policy implementation
 *  XXX: KEEP_THREAD_ALIVE policy meens that after run() returns thread does not exit
 *  but waits on a condition to be activated. Any signal on a condition will
 *  trigger run() execution.
 */
class Policy_KEEP_THREAD_ALIVE
{

public:  //// Create/Copy/Destroy

        Policy_KEEP_THREAD_ALIVE();

        virtual
	~Policy_KEEP_THREAD_ALIVE();

public:	 //// Usage

    /**
     *  Shutdown the TaskPolicy (with associated thread).
     *  XXX: Implements gracefull shutdown. Thread exits at run() termination.
     */
    void shutdown();

protected:

    virtual void run() = 0;

    virtual void cleanup() = 0;

    /**
     *  Implements KEEP_THREAD_ALIVE policy.
     */
    static void* thread_proc(void* arg);

public:

    void signal();

public:  // State

    /**
     *  Implements 'is active' indicator.
     *  XXX: Returns true if thread is alive. 
     */
    bool is_running() const;

    /**
     *  Returns shutdown indicator.
     */
    bool is_shutdown() const;

private:

    mutable Mutex _mutex;		// Mutex for the condition.
    mutable StatefullCondition _cond;	// Thread waiting condition.

    bool _running;		// Thread state: true if thread is alive.
    bool _shutdown;
};

/**
 *  RUN_THREAD_ONCE policy implementation
 *  XXX: THREAD_EXIT_UPON_RETURN policy meens that after run()
 *  returns thread exits.
 */
class Policy_RUN_THREAD_ONCE
{
public:  // Create/Copy/Destroy

    Policy_RUN_THREAD_ONCE();

    virtual ~Policy_RUN_THREAD_ONCE();

public:  // Usage

    /**
     *  Shutdown the TaskPolicy (with associated thread).
     *  XXX: Implements gracefull shutdown. Thread exits at run() termination. 
     */
    void shutdown();

protected:

    virtual void run() = 0;

    virtual void cleanup() = 0;

    /**
     *  Implements THREAD_EXIT_UPON_RETURN policy.
     *  XXX: Thread is launched with start() function.
     */
    static void* thread_proc(void* arg);

public:  // State

    /**
     *  Returns active indicator.
     */
    bool is_running() const;

    /**
     *  Returns shutdown indicator.
     */
    bool is_shutdown() const;

private:

    mutable Mutex _mutex;	// Mutex for flags.
    bool _running;		// Thread state: true if thread is alive.
    bool _shutdown;
};

typedef Policy_RUN_THREAD_ONCE RUN_THREAD_ONCE;
typedef Policy_KEEP_THREAD_ALIVE KEEP_THREAD_ALIVE;

};  // namespace tpl

#endif //__TPL_TASK_POLICY_HH__
