// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "task_policy.hh"
#include "libtpl/thread/lock_guards.hh"
#include "libtpl/thread/thread.hh"

#include <iostream>

using namespace tpl;

////////////////////////////////////////////////////////////
//                   KEEP_THREAD_ALIVE                    //
////////////////////////////////////////////////////////////

Policy_KEEP_THREAD_ALIVE::Policy_KEEP_THREAD_ALIVE() :
    _cond(_mutex), _running(false), _shutdown(false)
{
}

Policy_KEEP_THREAD_ALIVE::~Policy_KEEP_THREAD_ALIVE() 
{
}

void*
Policy_KEEP_THREAD_ALIVE::thread_proc(void* arg) 
{
    Policy_KEEP_THREAD_ALIVE* p = static_cast<Policy_KEEP_THREAD_ALIVE*>(arg);

    do {
    	LockGuard<Mutex> guard(p->_mutex);
    	p->_running = true;
    	p->_shutdown = false;
    } while(0);

    while (!p->_shutdown) {
    	do {
    	    LockGuard<Mutex> guard(p->_mutex);
    	    p->_cond.wait();
    	} while(0);

    	try {
    	    p->run();
    	}
    	catch (...) {
    	    std::cerr << "Thread " << Thread::current_thread_id()
    	         << ": Unknown exception caught on a thread" << std::endl;
    	}
    }

    do {
    	LockGuard<Mutex> lock(p->_mutex);
    	p->_running = false;
    	p->_shutdown = false;
    	p->cleanup();
    } while(0);

    return 0;
}

void
Policy_KEEP_THREAD_ALIVE::signal()
{
    LockGuard<Mutex> guard(_mutex);
    _cond.signal();
}

void
Policy_KEEP_THREAD_ALIVE::shutdown()
{
    LockGuard<Mutex> guard(_mutex);
    _shutdown = true;
    _cond.signal();
}

bool
Policy_KEEP_THREAD_ALIVE::is_running() const
{
    LockGuard<Mutex> guard(_mutex);
    return _running;
}

bool
Policy_KEEP_THREAD_ALIVE::is_shutdown() const
{
    LockGuard<Mutex> guard(_mutex);
    return _shutdown;
}


////////////////////////////////////////////////////////////
//                     RUN_THREAD_ONCE                    //
////////////////////////////////////////////////////////////

Policy_RUN_THREAD_ONCE::Policy_RUN_THREAD_ONCE() :
    _running(false), _shutdown(false)
{
}

Policy_RUN_THREAD_ONCE::~Policy_RUN_THREAD_ONCE()
{
}

void*
Policy_RUN_THREAD_ONCE::thread_proc(void* arg)
{
    Policy_RUN_THREAD_ONCE* p = (Policy_RUN_THREAD_ONCE*) arg;

    do {
    	LockGuard<Mutex> guard(p->_mutex);
    	p->_running = true;
    } while(0);

    try {
    	p->run();
    }
    catch (...) {
    	std::cerr << "Thread " << Thread::current_thread_id()
    	     << ": Unknown exception caught on a thread" << std::endl;
    }

    do {
    	LockGuard<Mutex> guard(p->_mutex);
    	p->_running = false;
    	p->cleanup();
    } while(0);
    return 0;
}

void
Policy_RUN_THREAD_ONCE::shutdown()
{
    LockGuard<Mutex> guard(_mutex);
    _shutdown = true;
}

bool
Policy_RUN_THREAD_ONCE::is_running() const
{
    LockGuard<Mutex> guard(_mutex);
    return _running;
}

bool
Policy_RUN_THREAD_ONCE::is_shutdown() const
{
    LockGuard<Mutex> guard(_mutex);
    return _shutdown;
}

