// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include <errno.h>

#include "task.hh"
#include "libtpl/thread/lock.hh"
#include "libtpl/thread/condition.hh"
#include "libtpl/thread/lock_guards.hh"
#include "task_policy.hh"
#include "task_mgr.hh"
#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                     TaskBase                           //
////////////////////////////////////////////////////////////

TaskBase::~TaskBase()
{
}

////////////////////////////////////////////////////////////
//                     Task                               //
////////////////////////////////////////////////////////////

template <class LIFE_CYCLE>
Task<LIFE_CYCLE>::Task(TaskMode mode) : _mode(mode)
{
}

template <class LIFE_CYCLE>
Task<LIFE_CYCLE>::~Task() 
{
}

template <class LIFE_CYCLE>
void
Task<LIFE_CYCLE>::start()
{
    LIFE_CYCLE *th = this;
    TPL_ASSERT(th->is_running());

    if (!th->is_running()) {
    	_thread.set_thread_function(LIFE_CYCLE::thread_proc);
    	_thread.start(th);

    	if (_mode == TASK_DETACHED)
    	    _thread.detach();
    	else {
    	    TaskManager* mgr = TaskManager::instance();
    	    LockGuard<TaskManager> guard(*mgr);
    	    mgr->add(this);
    	}
    }
}

template <class LIFE_CYCLE>
void
Task<LIFE_CYCLE>::join()
{
    TPL_ASSERT(_mode != TASK_DETACHED);
    TPL_ASSERT(_mode != TASK_TEMPORARY);

    void *retval;
    while (true) {
    	int err = _thread.join(&retval);
    	if (err == ERROR_INTERRUPTED) {
    	    continue;
        }

    	TPL_ASSERT(err == 0);
    	break;
    }

    TaskManager *mgr = TaskManager::instance();
    LockGuard<TaskManager> guard(*mgr);
    mgr->remove(this);
}

template <class LIFE_CYCLE>
void
Task<LIFE_CYCLE>::cleanup()
{
    if (_mode == TASK_TEMPORARY) {
    	TaskManager *mgr = TaskManager::instance();
    	LockGuard<TaskManager> guard(*mgr);
    	mgr->remove(this);
    }
}

template <class LIFE_CYCLE>
void
Task<LIFE_CYCLE>::print_on(std::ostream& os) const
{
    os << id();
}

//------------------------------------------------------------
// Template Instantiations

template class Task<RUN_THREAD_ONCE>;
template class Task<KEEP_THREAD_ALIVE>;

