// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "libtpl/queues/linked_queue.hh"
#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                 Service<T, LIFE_CYCLE>                 //
////////////////////////////////////////////////////////////

template <class T, class LIFE_CYCLE>
Service<T, LIFE_CYCLE>::Service(size_t queue_limit) : _shared_queue(false)
{
    _queue = new LinkedBlockingQueue<T>(queue_limit);
}

template <class T, class LIFE_CYCLE>
Service<T, LIFE_CYCLE>::Service(BlockingQueue<T>* queue) : _shared_queue(true), _queue(queue)
{
}

template <class T, class LIFE_CYCLE>
Service<T, LIFE_CYCLE>::~Service()
{
    Task<LIFE_CYCLE>::shutdown();
    if (_queue->is_active())
    	_queue->deactivate();
    	_queue->clear();
    if (!_shared_queue)
    	delete _queue;
}

template <class T, class LIFE_CYCLE>
void
Service<T, LIFE_CYCLE>::reset_queue(size_t queue_limit)
{
    if (!_shared_queue)
        delete _queue;

    _shared_queue = false;
    _queue = new LinkedBlockingQueue<T>(queue_limit);
}

template <class T, class LIFE_CYCLE>
void
Service<T, LIFE_CYCLE>::set_queue(BlockingQueue<T>* queue)
{
    TPL_ASSERT(queue);

    if (!_shared_queue)
        delete _queue;

    _shared_queue = true;
    _queue = queue;
}

template <class T, class LIFE_CYCLE>
BlockingQueue<T>*
Service<T, LIFE_CYCLE>::queue()
{
    return _queue;
}

template <class T, class LIFE_CYCLE>
bool
Service<T, LIFE_CYCLE>::put(T* msg, int timeout)
{
    TPL_ASSERT(_queue);
    return _queue->put(msg, timeout);
}

template <class T, class LIFE_CYCLE>
bool
Service<T, LIFE_CYCLE>::put_bulk(std::list<T*> bulk_msg, int timeout)
{
    TPL_ASSERT(_queue);
    return _queue->put_bulk(bulk_msg, timeout);
}

template <class T, class LIFE_CYCLE>
T*
Service<T, LIFE_CYCLE>::get(int timeout)
{
    TPL_ASSERT(_queue);
    return _queue->get(timeout);
}

template <class T, class LIFE_CYCLE>
std::list<T*>
Service<T, LIFE_CYCLE>::get_bulk(int timeout)
{
    TPL_ASSERT(_queue);
    return _queue->get_bulk(timeout);
}

template <class T, class LIFE_CYCLE>
bool
Service<T, LIFE_CYCLE>::is_empty() const
{
    TPL_ASSERT(_queue);
    return _queue->is_empty();
}

template <class T, class LIFE_CYCLE>
size_t
Service<T, LIFE_CYCLE>::queue_size() const
{
    TPL_ASSERT(_queue);
    return _queue->size();
}

#ifdef TPL_DEBUG

template <class T, class LIFE_CYCLE>
bool
Service<T, LIFE_CYCLE>::is_locked() const
{
    TPL_ASSERT(_queue);
    return _queue->is_locked();
}

template <class T, class LIFE_CYCLE>
int
Service<T, LIFE_CYCLE>::queue_size_debug() const
{
    TPL_ASSERT(_queue);
    return _queue->size_debug();
}

template <class T, class LIFE_CYCLE>
int
Service<T, LIFE_CYCLE>::owner_thread() const
{
    TPL_ASSERT(_queue);
    return _queue->owner_thread();
}

#endif

template <class T, class LIFE_CYCLE>
void
Service<T, LIFE_CYCLE>::activate_queue()
{
    TPL_ASSERT(_queue);
    return _queue->activate();
}

template <class T, class LIFE_CYCLE>
void
Service<T, LIFE_CYCLE>::deactivate_queue()
{
    TPL_ASSERT(_queue);
    return _queue->deactivate();
}

template <class T, class LIFE_CYCLE>
void
Service<T, LIFE_CYCLE>::print_on(std::ostream&) const
{}
