// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_PRODUCER_HH__
#define __TPL_PRODUCER_HH__

#include "service.hh"
#include "consumer_panel.hh"

#include <iostream>

namespace tpl {

/**
 *  Producer - Consumer/Producer pattern.
 *  XXX: performs demaultiplexing of messages and
 *  delegetes message processing to available consumer (WORKER).
 */
template <typename T>
class Producer : public Service<T>
{
public:  // Create/Copy/Destroy

    Producer();
    virtual ~Producer();

    TPL_NO_COPY_TEMPLATE(Producer, T);

public:  // Usage

    /**
     *  Register consumer.
     */
    void register_consumer(Consumer<T>* consumer);

    /**
     *  Unregister consumer.
     */
    void unregister_consumer(Consumer<T>* consumer);

    /**
     *  Join all consumer threads and self thread.
     */
    void join_all();

    /**
     *  Returns number of registered consumers.
     */
    int consumers_count() const;

    /**
     *  Returns number of active consumers.
     */
    int active_count() const;

    using Service<T>::queue;
    using Service<T>::set_queue;

protected:

    /**
     *  Implemenets thread method of Task.
     *  XXX: All registered consumers started and 
     *  process() method invoked.
     */
    virtual void run();

    /**
     *  Implements message processing.
     *  XXX: Has to be implemented by specialized producer.
     */
    virtual void process() = 0;

    using Service<T>::activate_queue;
    using Service<T>::deactivate_queue;

protected:  // Printing

    virtual void print_on(std::ostream& os) const;

private:

    ConsumerPanel<T> _consumer_panel;
};

}; // namespace tpl

#ifndef NO_COMPILE_INSTANTIATE
#include "producer.cc"
#endif
#endif // __TPL_PRODUCER_HH__
