// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "libtpl/exceptions.hh"

////////////////////////////////////////////////////////////
//                      Producer                          //
////////////////////////////////////////////////////////////

template <class T>
Producer<T>::Producer () : _consumer_panel(queue())
{}

template <class T>
Producer<T>::~Producer ()
{}

template <class T>
void
Producer<T>::register_consumer(Consumer<T>* consumer)
{
    _consumer_panel.register_consumer(consumer);
}

template <class T>
void
Producer<T>::unregister_consumer(Consumer<T>* consumer)
{
    _consumer_panel.unregister_consumer(consumer);
}

template <class T>
void
Producer<T>::run()
{
    _consumer_panel.start_all();

    try {
    	process();
    }
    catch (ErrorBase& err) {
        std::cerr << "Consumer: " << err << std::endl;
    }
    catch (std::exception& ex) {
        std::cerr << "Consumer: exception" << ex.what() << std::endl;
    }
    catch (...) {
        std::cerr << "Consumer: unknown exception" << std::endl;
    }

    _consumer_panel.shutdown_all();
    deactivate_queue();
}

template <class T>
void
Producer<T>::join_all()
{
    _consumer_panel.join_all();
    this->join();
}

template <class T>
int
Producer<T>::consumers_count() const
{
    return _consumer_panel.size();
}

template <class T>
int
Producer<T>::active_count() const
{
    return _consumer_panel.active_count();
}

template <class T>
void
Producer<T>::print_on(std::ostream& os) const
{
    os << "Producer { " << _consumer_panel << std::endl;
    os << "}" << std::endl;
}
