// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_MSG_SERVICE_HH__
#define __TPL_MSG_SERVICE_HH__

#include "service.hh"
#include "msg.hh"

#include <iostream>

namespace tpl {

template <typename T>
class MessageChannel;

/**
 *  Base class for a publisher/subscriber service
 */
template <typename T>
class MessageService : public Service<Message<T> >
{
public:  // Create/Copy/Destroy

    MessageService(MessageChannel<T>* msg_channel);

    virtual ~MessageService();

    TPL_NO_COPY_TEMPLATE(MessageService, T);

public:  // Usage

    /**
     *  Sets active event channel.
     */
    void set_msg_channel(MessageChannel<T> *msg_channel);

    /**
     *  Subscribe for event.
     */
    void subscribe(const T& id);

    /**
     *
     *  Post event to event channel.
     */
    void post_message(Message<T>* msg);

protected:  // Printing

    virtual void print_on(std::ostream& os) const;

private:

    MessageChannel<T>* _msg_channel;   // Message channel.
};

};  // namespace tpl

#ifndef NO_COMPILE_INSTANTIATE
#include "msg_service.cc"
#endif
#endif // __TPL_MSG_SERVICE_HH__
