// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "msg_channel.hh"
#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                    MessageService                      //
////////////////////////////////////////////////////////////

template <typename T>
MessageService<T>::MessageService(MessageChannel<T>* msg_channel) : _msg_channel(msg_channel)
{}

template <typename T>
MessageService<T>::~MessageService()
{}

template <typename T>
void
MessageService<T>::set_msg_channel(MessageChannel<T>* msg_channel)
{
    TPL_ASSERT(msg_channel);
    TPL_ASSERT(!_msg_channel);

    _msg_channel = msg_channel;
}

template <typename T>
void
MessageService<T>::subscribe(const T& id)
{
    _msg_channel->subscribe(this, id);
}

template <typename T>
void
MessageService<T>::post_message(Message<T>* msg)
{
    _msg_channel->put(msg);
}

template <typename T>
void
MessageService<T>::print_on (std::ostream&) const
{}
