// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_MSG_CHANNEL_HH__
#define __TPL_MSG_CHANNEL_HH__

#include "service.hh"
#include "msg.hh"

#include <iostream>
#include <list>
#include <map>

namespace tpl {

template <typename T>
class MessageService;

/**
 *  Message channel.
 *  Message channal performs message propagation between async services.
 */
template <typename T>
class MessageChannel : public Service<Message<T> >
{
public:  // Create/Destroy/Copy

    MessageChannel(int timeout = 1000);

    virtual ~MessageChannel();

    TPL_NO_COPY_TEMPLATE(MessageChannel, T);

public:  // Usage

    /**
     *  Subscribe a MessageService to this MessageChannel
     *  to recieve all messages with specified id.
     */
    void subscribe(MessageService<T>* subscriber, const T& id);

protected:

    /**
     *  Message Channal Working Thread.
     *  XXX: Performes blocking call to get messages from
     *  the queue and pushes them to the
     *  appropriate consumer based on message id
     *  (to the subscribed consumers)
     *  If message queue is empty channel blocks on get().
     *  If there is no subscriber for the message id
     *  message is logged as an error and ignored
     */
    virtual void run();

protected:  // Printing

    virtual void print_on(std::ostream& os) const;

private:

    typedef std::list<MessageService<T>*> SubscriberList;
    typedef std::map<T, SubscriberList, std::less<T> > MessageMap;
    MessageMap _msg_map;  // Message-Subscribers map.
    int _timeout;
};

};  // namespace tpl

#ifndef NO_COMPILE_INSTANTIATE
#include "msg_channel.cc"
#endif
#endif // __TPL_MSG_CHANNEL_HH__
