// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "msg_service.hh"
#include "libtpl/debug.hh"

using namespace tpl;

////////////////////////////////////////////////////////////
//                  MessageChannel                        //
////////////////////////////////////////////////////////////

template <typename T>
MessageChannel<T>::MessageChannel(int timeout) : _timeout(timeout)
{}

template <typename T>
MessageChannel<T>::~MessageChannel()
{}

template <typename T>
void
MessageChannel<T>::subscribe(MessageService<T>* subscriber, const T& id)
{
    TPL_ASSERT(subscriber);

    typename MessageMap::iterator sli = _msg_map.find(id);
    if (sli != _msg_map.end()) {
    	SubscriberList* subscriber_list = &(sli->second);
    	typename SubscriberList::iterator i = subscriber_list->begin();
    	typename SubscriberList::iterator end = subscriber_list->end();
    	while (i != end) {
    	    	if ((*i) == subscriber) {
    	    	    return;
    	    	}
    	    	++i;
    	}
    	subscriber_list->push_back(subscriber);
    }
    else {
    	SubscriberList* subscriber_list = new SubscriberList();
    	subscriber_list->push_back(subscriber);
    	_msg_map[id] = *subscriber_list;
    }
}

template <typename T>
void
MessageChannel<T>::run()
{
    while(!this->is_shutdown()) {
    	Message<T>* msg = this->get(_timeout);

    	if (msg) {
    	    typename MessageMap::iterator sli = _msg_map.find(msg->id());
    	    if (sli != _msg_map.end()) {
    	    	SubscriberList& subscriber_list = sli->second;
    	    	typename SubscriberList::iterator i = subscriber_list.begin();
    	    	typename SubscriberList::iterator end = subscriber_list.end();
    	    	while (i != end) {
    	    	    ((MessageService<T>*)(*i))->put(msg->clone());
    	    	    ++i;
    	    	}
    	    }
    	    delete msg;
    	}
    }
}

template <typename T>
void
MessageChannel<T>::print_on(std::ostream& /* os */) const
{}
