// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_MSG_HH__
#define __TPL_MSG_HH__

#include <iostream>

namespace tpl {

template <typename T>
class Message;

template <typename T>
inline std::ostream& operator<< (std::ostream& os, const Message<T>& obj)
{
    obj.print_on ( os );
    return os;
}

/**
 *  Base message class.
 *  XXX: All messages in the system must be derived from this class.
 *  Each sub-class must emplement clone() method.
 */
template <typename T>
class Message
{
public:  // Create/destroy/Copy

    Message(const T& id) : _id(id) {}

    virtual ~Message() {}

public: // Usage

    /**
     *  Clones message object.
     *  XXX: Every derived message class must provide the clone method.
     *  This method will be used by MessageChannel to provide a copy of
     *  the message object to each of the subscribers.
     */
    virtual Message* clone() const { return new Message(_id); }

    /**
     *  Returns event id.
     */
    const T&  id() const { return _id; }

public:  // Printing

    friend std::ostream& operator<< <T>(std::ostream& os, const Message<T>& obj);

protected:

    virtual void print_on(std::ostream& os) const {
    	os << "Message [" << _id << "]";
    }

protected:

    T _id;  // Message id.
};

};  // namespace tpl

#endif // __TPL_MSG_HH__
