// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_CONSUMER_PANEL_HH__
#define __TPL_CONSUMER_PANEL_HH__

#include "consumer.hh"

#include <iostream>
#include <list>

namespace tpl {

template <class T>
class ConsumerPanel;

template <class T>
inline std::ostream& operator<< (std::ostream& os, const ConsumerPanel<T>& obj)
{
    obj.print_on(os);
    return os;
}

/**
 *  ConsumerPanel
 */
template <class T>
class ConsumerPanel
{
public:  // Create/Copy/Destroy

    ConsumerPanel(BlockingQueue<T>* queue);
    virtual  ~ConsumerPanel ();

    TPL_NO_COPY_TEMPLATE(ConsumerPanel, T);

public:  // Usage

    /**
     *  Register a consumer.
     */
    void register_consumer(Consumer<T>* consumer);

    /**
     *  Unregister a consumer.
     */
    void unregister_consumer(Consumer<T>* consumer);

    /**
     *  Start all consumers.
     */
    void start_all();

    /**
     *  Send shutdown signal to all consumers.
     */
    void shutdown_all();

    /**
     *  Join all consumer threads.
     */
    void join_all();

public: // State

    /**
     *  @return number of consumers registered in the panel.
     */
    int consumers_count() const { return _consumer_list.size(); }

    /**
     *
     *	Description: Join all consumer threads.
     */
    int active_count() const;

public:  // Printing

    friend std::ostream& operator<< <T>(std::ostream& os, const ConsumerPanel<T>& obj);

protected:

    virtual void print_on(std::ostream& os) const;

private:

    typedef std::list<Consumer<T>*> ConsumerList;

    BlockingQueue<T>* _queue;
    ConsumerList _consumer_list;
};

};  // namespace tpl

#ifndef NO_COMPILE_INSTANTIATE
#include "consumer_panel.cc"
#endif
#endif // __TPL_CONSUMER_PANEL_HH__
