// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

////////////////////////////////////////////////////////////
//                      ConsumerPanel                     //
////////////////////////////////////////////////////////////

template <class T>
ConsumerPanel<T>::ConsumerPanel(BlockingQueue<T>* queue) : _queue(queue)
{}

template <class T>
ConsumerPanel<T>::~ConsumerPanel()
{}

template <class T>
void
ConsumerPanel<T>::register_consumer(Consumer<T>* consumer)
{
    _consumer_list.push_back(consumer);
    consumer->set_queue(_queue);
}

template <class T>
void
ConsumerPanel<T>::unregister_consumer(Consumer<T>* consumer)
{
    typename ConsumerList::iterator i =
    	find(_consumer_list.begin(), _consumer_list.end(), consumer);
    if (i != _consumer_list.end()) {
    	_consumer_list.erase(i);
    	consumer->reset_queue();
    }
}

template <class T>
void
ConsumerPanel<T>::start_all()
{
    typename ConsumerList::const_iterator i = _consumer_list.begin();
    typename ConsumerList::const_iterator end = _consumer_list.end();

    while (i != end) {
        (*i)->start();
        i++;
    }
}

template <class T>
void
ConsumerPanel<T>::shutdown_all()
{
    typename ConsumerList::const_iterator i = _consumer_list.begin();
    typename ConsumerList::const_iterator end = _consumer_list.end();

    while (i != end) {
        (*i)->shutdown();
        i++;
    }
}

template <class T>
void
ConsumerPanel<T>::join_all()
{
    typename ConsumerList::const_iterator i = _consumer_list.begin();
    typename ConsumerList::const_iterator end = _consumer_list.end();

    while (i != end) {
        (*i)->join();
        i++;
    }
}

template <class T>
int
ConsumerPanel<T>::active_count() const
{
    typename ConsumerList::const_iterator i = _consumer_list.begin();
    typename ConsumerList::const_iterator end = _consumer_list.end();

    int count = 0;
    while (i != end) {
        if ((*i)->is_active()) ++count;
        i++;
    }
    return count;
}

template <class T>
void
ConsumerPanel<T>::print_on (std::ostream& os) const
{
    os << "ConsumerPanel {" << std::endl;

    typename ConsumerList::const_iterator i = _consumer_list.begin();
    typename ConsumerList::const_iterator end = _consumer_list.end();

    while (i != end) {
        os << (**i) << std::endl;
        i++;
    }

    os << "}";
}
