// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_CONSUMER_HH__
#define __TPL_CONSUMER_HH__

#include "service.hh"

#include <iostream>

namespace tpl {

/**
 *  Consumer (worker) - Consumer/Producer pattern.
 */
template <class T>
class Consumer : public Service<T>
{
public:  // Create/Copy/Destroy

    Consumer();
    Consumer(BlockingQueue<T>* queue);
    virtual ~Consumer();

    TPL_NO_COPY_TEMPLATE(Consumer, T);

public:  // State

    bool is_active() const { return _active; }

    using Service<T>::queue;
    using Service<T>::set_queue;

protected:

    /**
     *  Implemenets consumer.
     *  XXX: Messages are pulled out of the working queue and 
     *  processed by process() method.
     */
    virtual void run();

    /**
     *  Implements message processing.
     *  XXX: Has to be implemented by specialized consumer.
     */
    virtual void process(T* msg) = 0;

    using Service<T>::activate_queue;
    using Service<T>::deactivate_queue;

protected:  // Printing

    virtual void print_on(std::ostream& os) const;

protected:  // Data

    static const int _timeout = 1000;

    bool _active;
};

}; // namespace tpl

#ifndef NO_COMPILE_INSTANTIATE
#include "consumer.cc"
#endif
#endif //__TPL_CONSUMER_HH__
