// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "libtpl/exceptions.hh"

////////////////////////////////////////////////////////////
//                     Consumer                           //
////////////////////////////////////////////////////////////

template <class T>
Consumer<T>::Consumer() : Service<T>((BlockingQueue<T>*) 0), _active(false)
{}

template <class T>
Consumer<T>::Consumer(BlockingQueue<T>* queue) : Service<T>(queue)
{}

template <class T>
Consumer<T>::~Consumer()
{}

template <class T>
void
Consumer<T>::run()
{
    while (!this->is_shutdown()) {
    	T* msg = this->get(_timeout);
    	if (msg == NULL) continue;

    	_active = true;
    	try {
    	    process(msg);
    	}
    	catch (ErrorBase& err) {
    	    std::cerr << "Consumer: " << err << std::endl;
    	}
    	catch (std::exception& ex) {
    	    std::cerr << "Consumer: exception" << ex.what() << std::endl;
    	}
    	catch (...) {
    	    std::cerr << "Consumer: unknown exception" << std::endl;
    	}
    	delete msg;
    	_active = false;
    }
}

template <class T>
void
Consumer<T>::print_on(std::ostream&) const
{}
