// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_DEBUG_HH__
#define __TPL_DEBUG_HH__

#include "tpl_decls.hh"

// If this flag is set, failed assertions do not lead to any actions
// other than writing a record to the log file.
#define TPL_DEBUG_LOG_ASSERTIONS_ONLY  0x00000001
// If this flag is set, failed assertions will be displayed in a GUI message box
#define TPL_DEBUG_BLOCK_GUI_THREAD  0x00000002

#if defined(TPL_DEBUG)

  TPL_EXPORT bool __TPL_Assert_Fail(const char*, unsigned, const char*);
  TPL_EXPORT void __TPL_Debug_Break();
  TPL_EXPORT void __TPL_Trace(const char*, ...);

#  define TPL_ASSERT(p) \
    do {\
      if (!(p) && __TPL_Assert_Fail(__FILE__, __LINE__, #p))\
        __TPL_Debug_Break();\
    } while (0)

#  define VERIFY(f) TPL_ASSERT(f)
#  define TRACE     ::__TPL_Trace

  typedef void (*stack_print_hook_t)(char*, size_t);

  TPL_EXPORT void __TPL_Set_Debug_Option(uint32_t);
  TPL_EXPORT void __TPL_Set_Stack_Print_Hook(stack_print_hook_t);

#  define TPL_SET_DEBUG_OPTION      ::__TPL_Set_Debug_Option
#  define TPL_SET_STACK_PRINT_HOOK  ::__TPL_Set_Stack_Print_Hook

#else  // !TPL_DEBUG

#  define TPL_ASSERT(p) ((void)0)
#  define TPL_VERIFY(f) ((void)(f))

  inline void __TPL_Trace(...) { }
#  define TPL_TRACE     1 ? (void)0 : __TPL_Trace

  inline void __TPL_Set_Debug_Option(...) { }
  inline void __TPL_Set_Stack_Print_Hook(...) { }

#  define TPL_SET_DEBUG_OPTION      1 ? (void)0 : __TPL_Set_Debug_Option
#  define TPL_SET_STACK_PRINT_HOOK  1 ? (void)0 : __TPL_Set_Stack_Print_Hook

#endif // !TPL_DEBUG

/*
 * Compile time assertion.
 */
#ifndef static_assert
#define static_assert(a) switch (a) case 0: case (a):
#endif /* static_assert */

/*
 * A macro to avoid compilation warnings about unused functions arguments.
 * Note: this should be used only in C. In C++ just remove the argument name
 * in the function definition.
 */
#ifdef UNUSED
# undef UNUSED
#endif /* UNUSED */
#define UNUSED(var)	static_assert(sizeof(var) != 0)

#endif // __TPL_DEBUG_HH__
