// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "debug.hh"

#include <stdarg.h>
#include <stdlib.h>

#if defined(TPL_DEBUG)

extern uint32_t __tpl_debug_options;


bool __TPL_Assert_Fail(const char* file, unsigned line, const char* expr){
	fprintf(stderr, "\nAssertion failed:\nfile '%s', line %d\nCondition: '%s'", file, line, expr);
	abort();
	return false;
}

void __TPL_Debug_Break(){}

void __TPL_Trace(const char* format, ...){
	va_list l;
	va_start(l, format);
	vfprintf(stderr, format, l);
	va_end(l);
}

void __TPL_Set_Debug_Option(uint32_t) {}

#endif // TPL_DEBUG
