// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#ifndef __TPL_SELECT_INTERRUPTOR_HH__
#define __TPL_SELECT_INTERRUPTOR_HH__

namespace tpl {

/**
 *  SelectInterruptor - interrupts select/poll/epoll wait.
 */
class SelectInterruptor
{
public:
    // Constructor.
    SelectInterruptor();

    // Destructor.
    ~SelectInterruptor();

    // Interrupt the select call.
    void interrupt();

    // Reset the select interrupt. Returns true if the call was interrupted.
    bool reset();

    // Get the read descriptor to be passed to select.
    int read_fd() const { return _read_fd; }

private:
    // The read end of a connection used to interrupt the select call. This file
    // descriptor is passed to select such that when it is time to stop, a single
    // byte will be written on the other end of the connection and this
    // descriptor will become readable.
    int _read_fd;

    // The write end of a connection used to interrupt the select call. A single
    // byte may be written to this to wake up the select which is waiting for the
    // other end to become readable.
    int _write_fd;
};

}; // namespace tpl

#endif // __TPL_SELECT_INTERRUPTOR_HH__
