// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
//
// Copyright (c) 2007 Vyatta, Inc.
// All Rights Reserved.
//
// Author: Alex Allahverdiev <alex@vyatta.com>

#include "select_interruptor.hh"

#include <fcntl.h>
#include <unistd.h>

using namespace tpl;

// Constructor.
SelectInterruptor::SelectInterruptor()
{
    int pipe_fds[2];
    if (::pipe(pipe_fds) == 0)
    {
    	_read_fd = pipe_fds[0];
    	::fcntl(_read_fd, F_SETFL, O_NONBLOCK);
    	_write_fd = pipe_fds[1];
    	::fcntl(_write_fd, F_SETFL, O_NONBLOCK);
    }
}

// Destructor.
SelectInterruptor::~SelectInterruptor()
{
    if (_read_fd != -1)
    	::close(_read_fd);
    if (_write_fd != -1)
    	::close(_write_fd);
}

// Interrupt the select call.
void
SelectInterruptor::interrupt()
{
    char byte = 0;
    ::write(_write_fd, &byte, 1);
}

// Reset the select interrupt. Returns true if the call was interrupted.
bool
SelectInterruptor::reset()
{
    char data[1024];
    int bytes_read = ::read(_read_fd, data, sizeof(data));
    bool was_interrupted = (bytes_read > 0);
    while (bytes_read == sizeof(data))
    	bytes_read = ::read(_read_fd, data, sizeof(data));
    return was_interrupted;
}

