/*
 * Module: rl_validate.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#include <string>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <libxorp/ipv4.hh>
#include "rl_validate.hh"

bool
rl_validate::domain_name(const std::string &name)
{
  //we'll also want to validate the length as well
    if (name.length() > 63) {
	return false;
    }
    
    //allowable are letters (upper and lower), digits, "-"
    for (int i = 0; i < (int)name.length(); ++i) {
	//    printf("rl_validate::domain_name(): %d\n", name[i]);
	if (!(name[i] == 45 ||
	      name[i] == 46 ||
	      (name[i] > 47 && name[i] < 58) ||
	      (name[i] > 64 && name[i] < 91) ||
	      (name[i] > 96 && name[i] < 123))) {
	    return false;
	}
    }
    return true;
}

bool
rl_validate::timezone(const std::string &name)
{
  //checks against available timezones on box
  return true;
  UNUSED(name);
}

bool
rl_validate::time(const std::string &name)
{
  //checks the validatity of a timedate construct of form:MMDDhhmmYYYY.ss
  return true;
  UNUSED(name);
}

bool
rl_validate::is_ip_addr(const std::string &address)
{
  for (int i = 0; i < (int)address.length(); ++i) {
    if (address[i] > 47 && address[i] < 58) {
      //let's check to see if this is an ip addr
      string net_addr(address.substr(i, address.length() - i));
      in_addr_t addr = inet_network(net_addr.c_str());
      if (addr != (unsigned)-1) {
	return true;
      }
    }
  }
  return false;
}
